/* ============ */
/* genrunda.c	*/
/* ============ */
#include "miscdefs.h"
#include <rundefs.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

static
UCHAR	ChkBits[4096];

/* ==================================================================== */
/* GenRunData - Generates block of distinct random variates		*/
/* ==================================================================== */
void
GenRunData(RUN_DATA_STRU * RunData)
{
    int     Next;
    UINT    i;
    int     RandFound = FALSE;

    RunData->ActGenCount  = 0;
    RunData->ActRandCount = 0;

    memset(ChkBits, 0, sizeof(ChkBits));

    for (i = 0; i < RunData->NumRand; ++i)
    {
	RandFound = FALSE;

	do
	{
	    Next = RunData->RandFun();

	    /* --------------------------------- */
	    /* Bump Number of Variates Generated */
	    /* --------------------------------- */
	    ++(RunData->ActGenCount);

	    /* ------------------------------ */
	    /* Is This is a Distinct Variate? */
	    /* ------------------------------ */
	    if (TestBit(ChkBits, Next))
	    {
		/* --------------------------------- */
		/* No.  Has Max Count Been Exceeded? */
		/* --------------------------------- */
		if (RunData->ActGenCount > RunData->MaxGenCount)
		{
		    /* ---------- */
		    /* Yes. Punt. */
		    /* ---------- */
		    break;
		}
	    }
	    else
	    {
		/* -------------------- */
		/* Variate is Distinct. */
		/* -------------------- */
		SetBit(ChkBits, Next, 1);

		RandFound = TRUE;
	    }
	}
	while (!RandFound);

	/* ------------------------------------------ */
	/* Has Maximum Generator Count Been Exceeded? */
	/* ------------------------------------------ */
	if (RunData->ActGenCount > RunData->MaxGenCount)
	{
	    /* ---------- */
	    /* Yes. Punt. */
	    /* ---------- */
	    break;
	}

	if (!RandFound)
	{
	    break;
	}

	/* ------------------ */
	/* Store Next Variate */
	/* ------------------ */
	RunData->RandArray[i] = Next;

	/* -------------------------------- */
	/* Bump Number of Variates Retained */
	/* -------------------------------- */
	++(RunData->ActRandCount);
    }

    RunData->TotVariates += RunData->ActGenCount;

    RunData->CallStatus =
	RandFound && (RunData->ActGenCount <= RunData->MaxGenCount);
}
